function [msg] = writerawhdr(hdrFile,rawhdr)
%[msg] = writerawhdr(hdrFile,rawhdr)
%Write data to a '.hdr' file
%Input:
% hdrFile: name of a *.hdr file
% rawhdr: a rawhdr struct
%Output:
% msg: a short message
%
%20040318, jdlee
%

%check input paramters
if(nargin<1),
  error('no input filename');    
end

if(nargin<2),
  error('no rawhdr variable');    
end

if(~ishdrfile(hdrFile)),
    hdrFile=ext_img2hdr(hdrFile);
end

MachineFormat = rawhdr.byte_order;

%open hdr file
fid = fopen(hdrFile,'wb',MachineFormat);

%write hdr file---------------------------------------------
%write struct header_key
fwrite(fid, rawhdr.hk.sizeof_hdr,    'int32');
fwrite(fid, rawhdr.hk.data_type,     'uchar');
fwrite(fid, rawhdr.hk.db_name,       'uchar');
fwrite(fid, rawhdr.hk.extents,       'int32');
fwrite(fid, rawhdr.hk.session_error, 'int16');
fwrite(fid, rawhdr.hk.regular,       'uchar');
fwrite(fid, rawhdr.hk.hkey_un0,      'uchar');

%write struct image_dimension
fwrite(fid, rawhdr.dime.dim,        'int16');
fwrite(fid, rawhdr.dime.vox_units,  'uchar');
fwrite(fid, rawhdr.dime.cal_units,  'uchar');
fwrite(fid, rawhdr.dime.unused14,   'int16');
fwrite(fid, rawhdr.dime.datatype,   'int16');
fwrite(fid, rawhdr.dime.bitpix,     'int16');
fwrite(fid, rawhdr.dime.dim_un0,    'int16');
fwrite(fid, rawhdr.dime.pixdim,     'float');
fwrite(fid, rawhdr.dime.vox_offset, 'float');
fwrite(fid, rawhdr.dime.funused1,   'float');%SCALE in spm
fwrite(fid, rawhdr.dime.funused2,   'float');
fwrite(fid, rawhdr.dime.funused3,   'float');
fwrite(fid, rawhdr.dime.cal_max,    'float');
fwrite(fid, rawhdr.dime.cal_min,    'float');
fwrite(fid, rawhdr.dime.compressed, 'int32');%?float or int32
fwrite(fid, rawhdr.dime.verified,   'int32');%?float or int32
fwrite(fid, rawhdr.dime.glmax,      'int32');
fwrite(fid, rawhdr.dime.glmin,      'int32');

%write struct data_history
fwrite(fid, rawhdr.hist.descrip,     'uchar');
fwrite(fid, rawhdr.hist.aux_file,    'uchar');
fwrite(fid, rawhdr.hist.orient,      'uchar');
fwrite(fid, rawhdr.hist.origin,      'int16'); %spm-specific
fwrite(fid, rawhdr.hist.generated,   'uchar');
fwrite(fid, rawhdr.hist.scannum,     'uchar');
fwrite(fid, rawhdr.hist.patient_id,  'uchar');
fwrite(fid, rawhdr.hist.exp_date,    'uchar');
fwrite(fid, rawhdr.hist.exp_time,    'uchar');
fwrite(fid, rawhdr.hist.hist_un0,    'uchar');
fwrite(fid, rawhdr.hist.views,       'int32');
fwrite(fid, rawhdr.hist.vols_added,  'int32');
fwrite(fid, rawhdr.hist.start_field, 'int32');
fwrite(fid, rawhdr.hist.field_skip,  'int32');
fwrite(fid, rawhdr.hist.omax,        'int32');
fwrite(fid, rawhdr.hist.omin,        'int32');
fwrite(fid, rawhdr.hist.smax,        'int32');
fwrite(fid, rawhdr.hist.smin,        'int32');

%end of writing hdr file -----------------------------------
fclose(fid);
msg='ok';
return